//
//  table_C_O_L_R_.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.07.13.
//
//

#import <GSFontTools/TTable.h>
#import <GSFontTools/OTTables.h>

@class OTBaseGlyphRecord;
@class OTLayerRecord;
@class OTBaseGlyphList;
@class OTLayerList;
@class OTClipList;
@class OTVarIdxMap;
@class OTItemVariationStore;
@class OTClipRecord;
@class OTBaseGlyphPaintRecord;
@class OTPaint;
@class OTBaseGlyphRecordArray;
@class OTLayerRecordArray;
@class OTClipBox;

NS_ASSUME_NONNULL_BEGIN

@interface table_C_O_L_R_ : BaseTTXConverter
@end

@interface OTCOLR : OTBaseTable

@property uint16_t version;
@property (nonatomic, retain, nullable) OTBaseGlyphRecordArray *baseGlyphRecordArray;
@property (nonatomic, retain, nullable) OTBaseGlyphList *baseGlyphList;
@property (nonatomic, retain, nullable) OTLayerRecordArray *layerRecordArray;
@property (nonatomic, retain, nullable) OTLayerList *layerList;
@property (nonatomic, retain, nullable) OTClipList *clipList;
@property (nonatomic, retain, nullable) NSMutableArray<OTVarIdxMap *> *varIdxMap;
@property (nonatomic, retain, nullable) OTVarStore *varStore;

@end

@interface OTBaseGlyphRecordArray : OTBaseTable

@property (strong, nullable) NSMutableArray<OTBaseGlyphRecord *> *baseGlyphRecord;

@end

@interface OTBaseGlyphRecord : OTBaseTable {
	uint16_t _gID; // Glyph ID of reference glyph. This glyph is for reference only and is not rendered for color.
	NSRange _layerRange;
}
@property (nonatomic) uint16_t gID;
@property (nonatomic) NSRange layerRange;

@end

@interface OTLayerRecordArray : OTBaseTable

@property (strong, nullable) NSMutableArray<OTLayerRecord *> *layerRecord;

@end

@interface OTLayerRecord : OTBaseTable <NSCopying> {
	uint16_t _gID;			// Glyph ID of layer glyph (must be in z-order from bottom to top).
	uint16_t _paletteIndex; // Index value to use in the appropriate palette. This value must be less than numPaletteEntries in the CPAL table, except for the special case noted below. Each palette entry is 16 bits. A palette index of 0xFFFF is a special case indicating that the text foreground color should be used.
}
@property (nonatomic) uint16_t gID;
@property (nonatomic) uint16_t paletteIndex;

@end


@interface OTBaseGlyphList : OTBaseTable

@property (strong, nullable) NSMutableArray<OTBaseGlyphPaintRecord *> *baseGlyphPaintRecord;

@end

@interface OTLayerList : OTBaseTable

@property (strong, nullable) NSMutableArray<OTPaint *> *paint;

@end

@interface OTBaseGlyphPaintRecord : OTBaseTable {
	uint16 _baseGlyph;
	OTPaint *_paint; // Typically PaintColrLayers
};

@property uint16 baseGlyph;
@property (strong) OTPaint *paint;

@end

// Entries shall be sorted in ascending order of the `glyphID` field of the `BaseGlyphPaintRecord`s.
// typedef ArrayOf<BaseGlyphPaintRecord, uint32> BaseGlyphList;

// Only layers accessed via PaintColrLayers (format 1) need be encoded here.
// typedef ArrayOf<Offset32<Paint>, uint32> LayerList;

@interface OTClipList : OTUInt8FormatSwitchingBaseTable {
	NSMutableDictionary<NSString *, OTClipBox *> *_clips;
}

@property (strong) NSMutableDictionary<NSString *, OTClipBox *> *clips;

@end

// Index of the first variation record in the variation index map or
// variation store if no variation index map is present.
// A record with N variable fields finds them at OTVarIdxBase+0, ...,+N-1
// Use 0xFFFFFFFF to indicate no variation.
typedef uint32 OTVarIdxBase;

// The (Var)ColorStop alpha is multiplied into the alpha of the CPAL entry
// (converted to float -- divide by 255) looked up using paletteIndex to
// produce a final alpha.
@interface OTColorStop : OTBaseTable {
	float /*F2DOT14*/ _stopOffset;
	uint16 _paletteIndex;
	float /*F2DOT14*/ _alpha; // Default 1.0. Values outside [0.,1.] reserved.
};

@property float stopOffset;
@property uint16 paletteIndex;
@property float alpha;
@end

@interface OTVarColorStop : OTBaseTable {
	float /*F2DOT14*/ stopOffset; // VarIdx varIndexBase + 0
	uint16 paletteIndex;
	float /*F2DOT14*/ alpha; // Default 1.0. Values outside [0.,1.] reserved.
							 // VarIdx varIndexBase + 1
	OTVarIdxBase varIndexBase;
};
@end

typedef NS_ENUM(uint8, OTColorLineExtend) {
	OTColorLineExtendPad = 0,
	OTColorLineExtendRepeat = 1,
	OTColorLineExtendReflect = 2,
};

@interface OTColorLine : OTBaseTable {
	OTColorLineExtend _extend;
	NSArray<OTColorStop *> *_colorStops;
};

@property OTColorLineExtend extend;
@property (strong) NSArray<OTColorStop *> *colorStops;
@end

// This is a standard 2x3 matrix for 2D affine transformation.
@interface OTAffine2x3 : OTBaseTable {
	float _xx;
	float _yx;
	float _xy;
	float _yy;
	float _dx;
	float _dy;
};

@property float xx;
@property float yx;
@property float xy;
@property float yy;
@property float dx;
@property float dy;

@end

// Compositing modes are taken from https://www.w3.org/TR/compositing-1/
// NOTE: a brief audit of major implementations suggests most support most
// or all of the specified modes.
typedef NS_ENUM(uint8, OTCompositeMode) {
	// Porter-Duff modes
	// https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators
	OTCompositeModeClear = 0,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_clear
	OTCompositeModeSrc = 1,		  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_src
	OTCompositeModeDest = 2,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_dst
	OTCompositeModeSrcOver = 3,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_srcover
	OTCompositeModeDestOver = 4,  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_dstover
	OTCompositeModeSrcIn = 5,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_srcin
	OTCompositeModeDestIn = 6,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_dstin
	OTCompositeModeSrcOut = 7,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_srcout
	OTCompositeModeDestOut = 8,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_dstout
	OTCompositeModeSrcAtop = 9,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_srcatop
	OTCompositeModeDestAtop = 10, // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_dstatop
	OTCompositeModeXor = 11,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_xor
	OTCompositeModePlus = 12,	  // https://www.w3.org/TR/compositing-1/#porterduffcompositingoperators_plus

	// Blend modes
	// https://www.w3.org/TR/compositing-1/#blending
	OTCompositeModeScreen = 13,		// https://www.w3.org/TR/compositing-1/#blendingscreen
	OTCompositeModeOverlay = 14,	// https://www.w3.org/TR/compositing-1/#blendingoverlay
	OTCompositeModeDarken = 15,		// https://www.w3.org/TR/compositing-1/#blendingdarken
	OTCompositeModeLighten = 16,	// https://www.w3.org/TR/compositing-1/#blendinglighten
	OTCompositeModeColorDodge = 17, // https://www.w3.org/TR/compositing-1/#blendingcolordodge
	OTCompositeModeColorBurn = 18,	// https://www.w3.org/TR/compositing-1/#blendingcolorburn
	OTCompositeModeHardLight = 19,	// https://www.w3.org/TR/compositing-1/#blendinghardlight
	OTCompositeModeSoftLight = 20,	// https://www.w3.org/TR/compositing-1/#blendingsoftlight
	OTCompositeModeDifference = 21,	// https://www.w3.org/TR/compositing-1/#blendingdifference
	OTCompositeModeExclusion = 22,	// https://www.w3.org/TR/compositing-1/#blendingexclusion
	OTCompositeModeMultiply = 23,	// https://www.w3.org/TR/compositing-1/#blendingmultiply

	// Modes that, uniquely, do not operate on components
	// https://www.w3.org/TR/compositing-1/#blendingnonseparable
	OTCompositeModeHslHue = 24,		   // https://www.w3.org/TR/compositing-1/#blendinghue
	OTCompositeModeHslSaturation = 25, // https://www.w3.org/TR/compositing-1/#blendingsaturation
	OTCompositeModeHslColor = 26,	   // https://www.w3.org/TR/compositing-1/#blendingcolor
	OTCompositeModeHslLuminosity = 27, // https://www.w3.org/TR/compositing-1/#blendingluminosity
};

typedef NS_ENUM(NSUInteger, OTPaintFormat) {
	/// PaintColrLayers @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#format-1-paintcolrlayers
	OTPaintFormatPaintColrLayers = 1,
	/// PaintSolid @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-2-and-3-paintsolid-paintvarsolid
	OTPaintFormatPaintSolid = 2,
	/// PaintVarSolid @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-2-and-3-paintsolid-paintvarsolid
	OTPaintFormatPaintVarSolid = 3,
	/// PaintLinearGradient @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-4-and-5-paintlineargradient-paintvarlineargradient
	OTPaintFormatPaintLinearGradient = 4,
	/// PaintVarLinearGradient @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-4-and-5-paintlineargradient-paintvarlineargradient
	OTPaintFormatPaintVarLinearGradient = 5,
	/// PaintRadialGradient @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-6-and-7-paintradialgradient-paintvarradialgradient
	OTPaintFormatPaintRadialGradient = 6,
	/// PaintVarRadialGradient @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-6-and-7-paintradialgradient-paintvarradialgradient
	OTPaintFormatPaintVarRadialGradient = 7,
	/// PaintSweepGradient @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-8-and-9-paintsweepgradient-paintvarsweepgradient
	OTPaintFormatPaintSweepGradient = 8,
	/// PaintVarSweepGradient @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-8-and-9-paintsweepgradient-paintvarsweepgradient
	OTPaintFormatPaintVarSweepGradient = 9,
	/// PaintGlyph @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#format-10-paintglyph
	OTPaintFormatPaintGlyph = 10,
	/// PaintColrGlyph @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#format-11-paintcolrglyph
	OTPaintFormatPaintColrGlyph = 11,
	/// PaintTransform @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-12-and-13-painttransform-paintvartransform
	OTPaintFormatPaintTransform = 12,
	/// PaintVarTransform @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-12-and-13-painttransform-paintvartransform
	OTPaintFormatPaintVarTransform = 13,
	/// PaintTranslate @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-14-and-15-painttranslate-paintvartranslate
	OTPaintFormatPaintTranslate = 14,
	/// PaintVarTranslate @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-14-and-15-painttranslate-paintvartranslate
	OTPaintFormatPaintVarTranslate = 15,
	/// PaintScale @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintScale = 16,
	/// PaintVarScale @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintVarScale = 17,
	/// PaintScaleAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintScaleAroundCenter = 18,
	/// PaintVarScaleAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintVarScaleAroundCenter = 19,
	/// PaintScaleUniform @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintScaleUniform = 20,
	/// PaintVarScaleUniform @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintVarScaleUniform = 21,
	/// PaintScaleUniformAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintScaleUniformAroundCenter = 22,
	/// PaintVarScaleUniformAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-16-to-23-paintscale-and-variant-scaling-formats
	OTPaintFormatPaintVarScaleUniformAroundCenter = 23,
	/// PaintRotate @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter
	OTPaintFormatPaintRotate = 24,
	/// PaintVarRotate @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter
	OTPaintFormatPaintVarRotate = 25,
	/// PaintRotateAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter
	OTPaintFormatPaintRotateAroundCenter = 26,
	/// PaintVarRotateAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-24-to-27-paintrotate-paintvarrotate-paintrotatearoundcenter-paintvarrotatearoundcenter
	OTPaintFormatPaintVarRotateAroundCenter = 27,
	/// PaintSkew @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter
	OTPaintFormatPaintSkew = 28,
	/// PaintVarSkew @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter
	OTPaintFormatPaintVarSkew = 29,
	/// PaintSkewAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter
	OTPaintFormatPaintSkewAroundCenter = 30,
	/// PaintVarSkewAroundCenter @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#formats-28-to-31-paintskew-paintvarskew-paintskewaroundcenter-paintvarskewaroundcenter
	OTPaintFormatPaintVarSkewAroundCenter = 31,
	/// PaintComposite @discussion https://docs.microsoft.com/en-us/typography/opentype/spec/colr#format-32-paintcomposite
	OTPaintFormatPaintComposite = 32,
};

// Each layer is composited on top of previous with mode COMPOSITE_SRC_OVER.
// NOTE: uint8 size saves bytes in most cases and does not
// preclude use of large layer counts via PaintComposite or a tree
// of PaintColrLayers.
@interface OTPaint : OTUInt8FormatSwitchingBaseTable {

	// Format 1
	uint8 _numLayers;
	uint32 _firstLayerIndex; // index into COLRv1::layerList
	// Format 2
	uint16 _paletteIndex;
	float /*F2DOT14*/ _alpha; // Default 1.0. Values outside [0.,1.] reserved.
	// Format 3
	// uint16 _paletteIndex;
	// float /*F2DOT14*/ _alpha; // Default 1.0. Values outside [0.,1.] reserved.
	OTVarIdxBase _varIndexBase; // VarIdx varIndexBase + 0
	// Format 4
	OTColorLine *_colorLine;
	int16_t _x0;
	int16_t _y0;
	int16_t _x1;
	int16_t _y1;
	int16_t _x2; // _Normal; Equal to (x1,y1) in simple cases.
	int16_t _y2;
	// Format 5
	// VarColorLine *_colorLine;
	// int16_t _x0; // VarIdx varIndexBase + 0
	// int16_t _y0; // VarIdx varIndexBase + 1
	// int16_t _x1; // VarIdx varIndexBase + 2
	// int16_t _y1; // VarIdx varIndexBase + 3
	// int16_t _x2; // VarIdx varIndexBase + 4. _Normal; Equal to (x1,y1) in simple cases.
	// int16_t _y2; // VarIdx varIndexBase + 5
	// OTVarIdxBase _varIndexBase;
	// Format 6
	// VarColorLine *_colorLine;
	// int16_t _x0;
	// int16_t _y0;
	uint16_t _radius0;
	// int16_t _x1;
	// int16_t _y1;
	uint16_t _radius1;
	// Format 7
	// VarColorLine *_colorLine;
	// int16_t _x0; // VarIdx varIndexBase + 0
	// int16_t _y0; // VarIdx varIndexBase + 1
	// uint16_t _radius0; // VarIdx varIndexBase + 2
	// int16_t _x1; // VarIdx varIndexBase + 3
	// int16_t _y1; // VarIdx varIndexBase + 4
	// uint16_t _radius1; // VarIdx varIndexBase + 5
	// OTVarIdxBase _varIndexBase;
	// Format 8
	// VarColorLine *_colorLine;
	int16_t _centerX;
	int16_t _centerY;
	float /*F2DOT14*/ _startAngle; // 180° in counter-clockwise degrees per 1.0 of value
	float /*F2DOT14*/ _endAngle;   // 180° in counter-clockwise degrees per 1.0 of value
	// Format 9
	// VarColorLine *_colorLine;
	// int16_t _centerX; // VarIdx varIndexBase + 0
	// int16_t _centerY; // VarIdx varIndexBase + 1
	// float /*F2DOT14*/ _startAngle; // VarIdx varIndexBase + 2. 180° in counter-clockwise degrees per 1.0 of value
	// float /*F2DOT14*/ _endAngle; // VarIdx varIndexBase + 3. 180° in counter-clockwise degrees per 1.0 of value
	// OTVarIdxBase _varIndexBase;
	// Format 10
	OTPaint *_paint;
	uint16 _glyphID; // not a COLR-only gid
	// shall be less than maxp.numGlyphs
	// Format 11
	// uint16 _glyphID; // shall be a COLR gid
	// Format 12
	// PaintFormat *_paint;
	OTAffine2x3 *_transform;
	// Format 13
	// PaintFormat *_paint;
	// Offset24<VarAffine2x3> _transform;
	// Format 14
	// PaintFormat *_paint;
	int16_t _dx;
	int16_t _dy;
	// Format 15
	// PaintFormat *_paint;
	// int16_t _dx; // VarIdx varIndexBase + 0
	// int16_t _dy; // VarIdx varIndexBase + 1
	// OTVarIdxBase _varIndexBase;
	// Format 16
	// PaintFormat *_paint;
	float /*F2DOT14*/ _scaleX;
	float /*F2DOT14*/ _scaleY;
	// Format 17
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _scaleX; // VarIdx varIndexBase + 0
	// float /*F2DOT14*/ _scaleY; // VarIdx varIndexBase + 1
	// OTVarIdxBase _varIndexBase;
	// Format 18
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _scaleX;
	// float /*F2DOT14*/ _scaleY;
	// int16_t _centerX;
	// int16_t _centerY;
	// Format 19
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _scaleX; // VarIdx varIndexBase + 0
	// float /*F2DOT14*/ _scaleY; // VarIdx varIndexBase + 1
	// int16_t _centerX; // VarIdx varIndexBase + 2
	// int16_t _centerY; // VarIdx varIndexBase + 3
	// OTVarIdxBase _varIndexBase;
	// Format 20
	// PaintFormat *_paint;
	float /*F2DOT14*/ _scale;
	// Format 21
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _scale; // VarIdx varIndexBase + 0
	// OTVarIdxBase _varIndexBase;
	// Format 22
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _scale;
	// int16_t _centerX;
	// int16_t _centerY;
	// Format 23
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _scale; // VarIdx varIndexBase + 0
	// int16_t _centerX; // VarIdx varIndexBase + 1
	// int16_t _centerY; // VarIdx varIndexBase + 2
	// OTVarIdxBase _varIndexBase;
	// Format 24
	// PaintFormat *_paint;
	float /*F2DOT14*/ _angle; // 180° in counter-clockwise degrees per 1.0 of value
	// Format 25
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _angle; // VarIdx varIndexBase + 0. 180° in counter-clockwise degrees per 1.0 of value
	// OTVarIdxBase _varIndexBase;
	// Format 26
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _angle; // 180° in counter-clockwise degrees per 1.0 of value
	// int16_t _centerX;
	// int16_t _centerY;
	// Format 27
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _angle; // VarIdx varIndexBase + 0. 180° in counter-clockwise degrees per 1.0 of value
	// int16_t _centerX; // VarIdx varIndexBase + 1
	// int16_t _centerY; // VarIdx varIndexBase + 2
	// OTVarIdxBase _varIndexBase;
	// Format 28
	// PaintFormat *_paint;
	float /*F2DOT14*/ _xSkewAngle; // 180° in counter-clockwise degrees per 1.0 of value
	float /*F2DOT14*/ _ySkewAngle; // 180° in counter-clockwise degrees per 1.0 of value
	// Format 29
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _xSkewAngle; // VarIdx varIndexBase + 0. 180° in counter-clockwise degrees per 1.0 of value
	// float /*F2DOT14*/ _ySkewAngle; // VarIdx varIndexBase + 1. 180° in counter-clockwise degrees per 1.0 of value
	// OTVarIdxBase _varIndexBase;
	// Format 30
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _xSkewAngle; // 180° in counter-clockwise degrees per 1.0 of value
	// float /*F2DOT14*/ _ySkewAngle; // 180° in counter-clockwise degrees per 1.0 of value
	// int16_t _centerX;
	// int16_t _centerY;
	// Format 31
	// PaintFormat *_paint;
	// float /*F2DOT14*/ _xSkewAngle; // VarIdx varIndexBase + 0. 180° in counter-clockwise degrees per 1.0 of value
	// float /*F2DOT14*/ _ySkewAngle; // VarIdx varIndexBase + 1. 180° in counter-clockwise degrees per 1.0 of value
	// int16_t _centerX; // VarIdx varIndexBase + 2
	// int16_t _centerY; // VarIdx varIndexBase + 3
	// OTVarIdxBase _varIndexBase;
	// Format 32
	OTPaint *_sourcePaint;
	OTCompositeMode _compositeMode; // If mode is unrecognized use COMPOSITE_CLEAR
	OTPaint *_backdropPaint;
}

// Format 1
@property uint8 numLayers;
@property uint32 firstLayerIndex; // index into COLRv1::layerList
// Format 2
@property uint16 paletteIndex;
@property float /*F2DOT14*/ alpha; // Default 1.0. Values outside [0.,1.] reserved.
// Format 3
@property OTVarIdxBase varIndexBase; // VarIdx varIndexBase + 0
// Format 4
@property (strong) OTColorLine *colorLine;
@property int16_t x0;
@property int16_t y0;
@property int16_t x1;
@property int16_t y1;
@property int16_t x2; // Normal; Equal to (x1,y1) in simple cases.
@property int16_t y2;
// Format 5
// Format 6
@property uint16_t radius0;
@property uint16_t radius1;
// Format 7
// Format 8
@property int16_t centerX;
@property int16_t centerY;
@property float /*F2DOT14*/ startAngle; // 180° in counter-clockwise degrees per 1.0 of value
@property float /*F2DOT14*/ endAngle;	// 180° in counter-clockwise degrees per 1.0 of value
// Format 9
// Format 10
@property (strong) OTPaint *paint;
@property uint16 glyphID; // not a COLR-only gid, shall be less than maxp.numGlyphs
// Format 11
// Format 12
@property (strong) OTAffine2x3 *transform;
// Format 13
// Format 14
@property int16_t dx;
@property int16_t dy;
// Format 15
// Format 16
@property float /*F2DOT14*/ scaleX;
@property float /*F2DOT14*/ scaleY;
// Format 17
// Format 18
// Format 19
// Format 20
@property float /*F2DOT14*/ scale;
// Format 21
// Format 22
// Format 23
// Format 24
@property float /*F2DOT14*/ angle; // 180° in counter-clockwise degrees per 1.0 of value
// Format 25
// Format 26
// Format 27
// Format 28
@property float /*F2DOT14*/ xSkewAngle; // 180° in counter-clockwise degrees per 1.0 of value
@property float /*F2DOT14*/ ySkewAngle; // 180° in counter-clockwise degrees per 1.0 of value
// Format 29
// Format 30
// Format 31
// Format 32
@property (strong) OTPaint *sourcePaint;
@property OTCompositeMode compositeMode; // If mode is unrecognized use OTCompositeModeClear
@property (strong) OTPaint *backdropPaint;

- (instancetype)initWithFormat:(OTPaintFormat)format;

@end

NS_ASSUME_NONNULL_END
